/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.odps;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.support.odps.JSONWritable;
import com.alibaba.fastjson2.util.IOUtils;
import com.aliyun.odps.io.Text;
import com.aliyun.odps.io.Writable;
import com.aliyun.odps.udf.UDF;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class JSONExtractScalar
extends UDF {
    static final byte[] BYTES_TRUE = "true".getBytes(StandardCharsets.UTF_8);
    static final byte[] BYTES_FALSE = "false".getBytes(StandardCharsets.UTF_8);
    static final byte[] BYTES_NULL = "null".getBytes(StandardCharsets.UTF_8);
    final JSONPath path;
    JSONWritable text = new JSONWritable();
    ExtractValueConsumer valueConsumer = new ExtractValueConsumer();

    public JSONExtractScalar(String path) {
        this.path = JSONPath.of(path);
    }

    public Writable eval(Text input) {
        JSONReader parser = JSONReader.of(input.getBytes(), 0, input.getLength(), StandardCharsets.UTF_8);
        this.path.extractScalar(parser, this.valueConsumer);
        return this.text;
    }

    class ExtractValueConsumer
    implements ValueConsumer {
        ExtractValueConsumer() {
        }

        @Override
        public void accept(byte[] bytes, int off, int len) {
            JSONExtractScalar.this.text.bytes = bytes;
            JSONExtractScalar.this.text.off = off;
            JSONExtractScalar.this.text.length = len;
        }

        @Override
        public void acceptNull() {
            JSONExtractScalar.this.text.set(BYTES_NULL);
        }

        @Override
        public void accept(boolean val2) {
            JSONExtractScalar.this.text.set(val2 ? BYTES_TRUE : BYTES_FALSE);
        }

        @Override
        public void accept(int val2) {
            int size = val2 < 0 ? IOUtils.stringSize(-val2) + 1 : IOUtils.stringSize(val2);
            JSONExtractScalar.this.text.setCapacity(size, false);
            byte[] bytes = JSONExtractScalar.this.text.bytes;
            IOUtils.getChars(val2, size, bytes);
            JSONExtractScalar.this.text.length = size;
        }

        @Override
        public void accept(long val2) {
            int size = val2 < 0L ? IOUtils.stringSize(-val2) + 1 : IOUtils.stringSize(val2);
            JSONExtractScalar.this.text.setCapacity(size, false);
            byte[] bytes = JSONExtractScalar.this.text.bytes;
            IOUtils.getChars(val2, size, bytes);
            JSONExtractScalar.this.text.length = size;
        }

        @Override
        public void accept(Number val2) {
            if (val2 instanceof Integer) {
                this.accept(val2.intValue());
                return;
            }
            if (val2 instanceof Long) {
                this.accept(val2.longValue());
                return;
            }
            String str = val2.toString();
            JSONExtractScalar.this.text.set(str);
        }

        @Override
        public void accept(String val2) {
            JSONExtractScalar.this.text.set(val2);
        }

        @Override
        public void accept(Map object) {
            JSONExtractScalar.this.text.set(JSON.toJSONBytes(object));
        }

        @Override
        public void accept(List array) {
            JSONExtractScalar.this.text.set(JSON.toJSONBytes(array));
        }
    }
}

