/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.lang.reflect.Method;
import org.apache.ibatis.ognl.ASTConst;
import org.apache.ibatis.ognl.NodeType;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlOps;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.ExpressionCompiler;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

public class ASTStaticMethod
extends SimpleNode
implements NodeType {
    private String _className;
    private String _methodName;
    private Class _getterClass;

    public ASTStaticMethod(int id) {
        super(id);
    }

    public ASTStaticMethod(OgnlParser p, int id) {
        super(p, id);
    }

    void init(String className, String methodName) {
        this._className = className;
        this._methodName = methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Object[] args = OgnlRuntime.getObjectArrayPool().create(this.jjtGetNumChildren());
        Object root = context.getRoot();
        try {
            int icount = args.length;
            for (int i2 = 0; i2 < icount; ++i2) {
                args[i2] = this._children[i2].getValue(context, root);
            }
            Object object = OgnlRuntime.callStaticMethod(context, this._className, this._methodName, args);
            return object;
        }
        finally {
            OgnlRuntime.getObjectArrayPool().recycle(args);
        }
    }

    public Class getGetterClass() {
        return this._getterClass;
    }

    public Class getSetterClass() {
        return this._getterClass;
    }

    public String toString() {
        String result = "@" + this._className + "@" + this._methodName;
        result = result + "(";
        if (this._children != null && this._children.length > 0) {
            for (int i2 = 0; i2 < this._children.length; ++i2) {
                if (i2 > 0) {
                    result = result + ", ";
                }
                result = result + this._children[i2];
            }
        }
        result = result + ")";
        return result;
    }

    public String toGetSourceString(OgnlContext context, Object target) {
        String result = this._className + "#" + this._methodName + "(";
        try {
            Class clazz = OgnlRuntime.classForName(context, this._className);
            Method m = OgnlRuntime.getMethod(context, clazz, this._methodName, this._children, true);
            if (clazz == null || m == null) {
                throw new UnsupportedCompilationException("Unable to find class/method combo " + this._className + " / " + this._methodName);
            }
            if (!context.getMemberAccess().isAccessible(context, clazz, m, this._methodName)) {
                throw new UnsupportedCompilationException("Method is not accessible, check your jvm runtime security settings. For static class method " + this._className + " / " + this._methodName);
            }
            if (this._children != null && this._children.length > 0) {
                Class<?>[] parms = m.getParameterTypes();
                for (int i2 = 0; i2 < this._children.length; ++i2) {
                    Class valueClass;
                    if (i2 > 0) {
                        result = result + ", ";
                    }
                    Class prevType = context.getCurrentType();
                    Object value = this._children[i2].getValue(context, context.getRoot());
                    String parmString = this._children[i2].toGetSourceString(context, context.getRoot());
                    if (parmString == null || parmString.trim().length() < 1) {
                        parmString = "null";
                    }
                    if (ASTConst.class.isInstance(this._children[i2])) {
                        context.setCurrentType(prevType);
                    }
                    parmString = ExpressionCompiler.getRootExpression(this._children[i2], context.getRoot(), context) + parmString;
                    String cast = "";
                    if (ExpressionCompiler.shouldCast(this._children[i2])) {
                        cast = (String)context.remove("_preCast");
                    }
                    if (cast == null) {
                        cast = "";
                    }
                    if (!ASTConst.class.isInstance(this._children[i2])) {
                        parmString = cast + parmString;
                    }
                    Class clazz2 = valueClass = value != null ? value.getClass() : null;
                    if (NodeType.class.isAssignableFrom(this._children[i2].getClass())) {
                        valueClass = ((NodeType)((Object)this._children[i2])).getGetterClass();
                    }
                    if (valueClass != parms[i2]) {
                        if (parms[i2].isArray()) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(parms[i2]) + ")ognl.OgnlOps.toArray(" + parmString + ", " + parms[i2].getComponentType().getName() + ".class, true)", parms[i2]);
                        } else if (parms[i2].isPrimitive()) {
                            Class wrapClass = OgnlRuntime.getPrimitiveWrapperClass(parms[i2]);
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "((" + wrapClass.getName() + ")ognl.OgnlOps.convertValue(" + parmString + "," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), parms[i2]);
                        } else if (parms[i2] != Object.class) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + parms[i2].getName() + ")ognl.OgnlOps.convertValue(" + parmString + "," + parms[i2].getName() + ".class)", parms[i2]);
                        } else if (NodeType.class.isInstance(this._children[i2]) && ((NodeType)((Object)this._children[i2])).getGetterClass() != null && Number.class.isAssignableFrom(((NodeType)((Object)this._children[i2])).getGetterClass()) || valueClass.isPrimitive()) {
                            parmString = " ($w) " + parmString;
                        } else if (valueClass.isPrimitive()) {
                            parmString = "($w) " + parmString;
                        }
                    }
                    result = result + parmString;
                }
            }
            result = result + ")";
            try {
                Object contextObj = this.getValueBody(context, target);
                context.setCurrentObject(contextObj);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (m != null) {
                this._getterClass = m.getReturnType();
                context.setCurrentType(m.getReturnType());
                context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return result;
    }

    public String toSetSourceString(OgnlContext context, Object target) {
        return this.toGetSourceString(context, target);
    }
}

