/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.reflection.Jdk;
import org.apache.ibatis.reflection.ParamNameUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class ParamNameResolver {
    private static final String GENERIC_NAME_PREFIX = "param";
    private final SortedMap<Integer, String> names;
    private boolean hasParamAnnotation;

    public ParamNameResolver(Configuration config, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int paramCount = paramAnnotations.length;
        for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
            if (ParamNameResolver.isSpecialParameter(paramTypes[paramIndex])) continue;
            String name = null;
            for (Annotation annotation : paramAnnotations[paramIndex]) {
                if (!(annotation instanceof Param)) continue;
                this.hasParamAnnotation = true;
                name = ((Param)annotation).value();
                break;
            }
            if (name == null) {
                if (config.isUseActualParamName()) {
                    name = this.getActualParamName(method, paramIndex);
                }
                if (name == null) {
                    name = String.valueOf(map.size());
                }
            }
            map.put(paramIndex, name);
        }
        this.names = Collections.unmodifiableSortedMap(map);
    }

    private String getActualParamName(Method method, int paramIndex) {
        if (Jdk.parameterExists) {
            return ParamNameUtil.getParamNames(method).get(paramIndex);
        }
        return null;
    }

    private static boolean isSpecialParameter(Class<?> clazz) {
        return RowBounds.class.isAssignableFrom(clazz) || ResultHandler.class.isAssignableFrom(clazz);
    }

    public String[] getNames() {
        return this.names.values().toArray(new String[0]);
    }

    public Object getNamedParams(Object[] args) {
        int paramCount = this.names.size();
        if (args == null || paramCount == 0) {
            return null;
        }
        if (!this.hasParamAnnotation && paramCount == 1) {
            return args[this.names.firstKey()];
        }
        MapperMethod.ParamMap<Object> param = new MapperMethod.ParamMap<Object>();
        int i2 = 0;
        for (Map.Entry<Integer, String> entry : this.names.entrySet()) {
            param.put(entry.getValue(), args[entry.getKey()]);
            String genericParamName = GENERIC_NAME_PREFIX + String.valueOf(i2 + 1);
            if (!this.names.containsValue(genericParamName)) {
                param.put(genericParamName, args[entry.getKey()]);
            }
            ++i2;
        }
        return param;
    }
}

