/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Arrays;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilderSupport;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.util.Assert;

public final class MessageBuilder
extends MessageBuilderSupport<Message> {
    private static final String MESSAGE_CANNOT_BE_NULL = "'message' cannot be null";
    private static final String BODY_CANNOT_BE_NULL = "'body' cannot be null";
    private final byte[] body;

    public static MessageBuilder withBody(byte[] body2) {
        Assert.notNull((Object)body2, BODY_CANNOT_BE_NULL);
        return new MessageBuilder(body2);
    }

    public static MessageBuilder withClonedBody(byte[] body2) {
        Assert.notNull((Object)body2, BODY_CANNOT_BE_NULL);
        return new MessageBuilder(Arrays.copyOf(body2, body2.length));
    }

    public static MessageBuilder withBody(byte[] body2, int from, int to) {
        Assert.notNull((Object)body2, BODY_CANNOT_BE_NULL);
        return new MessageBuilder(Arrays.copyOfRange(body2, from, to));
    }

    public static MessageBuilder fromMessage(Message message) {
        Assert.notNull((Object)message, MESSAGE_CANNOT_BE_NULL);
        return new MessageBuilder(message);
    }

    public static MessageBuilder fromClonedMessage(Message message) {
        Assert.notNull((Object)message, MESSAGE_CANNOT_BE_NULL);
        byte[] body2 = message.getBody();
        Assert.notNull((Object)body2, BODY_CANNOT_BE_NULL);
        return new MessageBuilder(Arrays.copyOf(body2, body2.length), message.getMessageProperties());
    }

    private MessageBuilder(byte[] body2) {
        this.body = body2;
    }

    private MessageBuilder(Message message) {
        this(message.getBody(), message.getMessageProperties());
    }

    private MessageBuilder(byte[] body2, MessageProperties properties) {
        this.body = body2;
        this.copyProperties(properties);
    }

    public MessageBuilder andProperties(MessageProperties properties) {
        this.setProperties(properties);
        return this;
    }

    @Override
    public Message build() {
        return new Message(this.body, this.buildProperties());
    }
}

