/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.config.AbstractRetryOperationsInterceptorFactoryBean;
import org.springframework.amqp.rabbit.retry.MessageBatchRecoverer;
import org.springframework.amqp.rabbit.retry.MessageRecoverer;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.retry.support.RetryTemplate;

public class StatelessRetryOperationsInterceptorFactoryBean
extends AbstractRetryOperationsInterceptorFactoryBean {
    private static Log logger = LogFactory.getLog(StatelessRetryOperationsInterceptorFactoryBean.class);

    @Override
    public RetryOperationsInterceptor getObject() {
        RetryOperationsInterceptor retryInterceptor = new RetryOperationsInterceptor();
        RetryOperations retryTemplate = this.getRetryOperations();
        if (retryTemplate == null) {
            retryTemplate = new RetryTemplate();
        }
        retryInterceptor.setRetryOperations(retryTemplate);
        retryInterceptor.setRecoverer(this.createRecoverer());
        return retryInterceptor;
    }

    private MethodInvocationRecoverer<?> createRecoverer() {
        return (args, cause) -> {
            MessageRecoverer messageRecoverer = this.getMessageRecoverer();
            Object arg = args[1];
            if (messageRecoverer == null) {
                logger.warn("Message(s) dropped on recovery: " + arg, cause);
            } else if (arg instanceof Message) {
                messageRecoverer.recover((Message)arg, cause);
            } else if (arg instanceof List && messageRecoverer instanceof MessageBatchRecoverer) {
                ((MessageBatchRecoverer)messageRecoverer).recover((List)arg, cause);
            }
            return null;
        };
    }

    @Override
    public Class<?> getObjectType() {
        return RetryOperationsInterceptor.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

