/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConsumerChannelRegistry;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public final class ConnectionFactoryUtils {
    private ConnectionFactoryUtils() {
    }

    public static boolean isChannelTransactional(Channel channel, ConnectionFactory connectionFactory) {
        if (channel == null || connectionFactory == null) {
            return false;
        }
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)TransactionSynchronizationManager.getResource(connectionFactory);
        return resourceHolder != null && resourceHolder.containsChannel(channel);
    }

    public static RabbitResourceHolder getTransactionalResourceHolder(ConnectionFactory connectionFactory, boolean synchedLocalTransactionAllowed) {
        return ConnectionFactoryUtils.getTransactionalResourceHolder(connectionFactory, synchedLocalTransactionAllowed, false);
    }

    public static RabbitResourceHolder getTransactionalResourceHolder(ConnectionFactory connectionFactory, boolean synchedLocalTransactionAllowed, boolean publisherConnectionIfPossible) {
        return ConnectionFactoryUtils.doGetTransactionalResourceHolder(connectionFactory, new RabbitResourceFactory(connectionFactory, synchedLocalTransactionAllowed, publisherConnectionIfPossible));
    }

    private static RabbitResourceHolder doGetTransactionalResourceHolder(ConnectionFactory connectionFactory, ResourceFactory resourceFactory) {
        Channel channel;
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        Assert.notNull((Object)resourceFactory, "ResourceFactory must not be null");
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)TransactionSynchronizationManager.getResource(connectionFactory);
        if (resourceHolder != null && (channel = resourceFactory.getChannel(resourceHolder)) != null) {
            return resourceHolder;
        }
        RabbitResourceHolder resourceHolderToUse = resourceHolder;
        if (resourceHolderToUse == null) {
            resourceHolderToUse = new RabbitResourceHolder();
        }
        Connection connection = resourceFactory.getConnection(resourceHolderToUse);
        Channel channel2 = null;
        try {
            channel2 = ConsumerChannelRegistry.getConsumerChannel(connectionFactory);
            if (channel2 == null && connection == null) {
                connection = resourceFactory.createConnection();
                if (resourceHolder == null && (resourceHolder = (RabbitResourceHolder)TransactionSynchronizationManager.getResource(connectionFactory)) != null) {
                    channel2 = resourceHolder.getChannel();
                    resourceHolderToUse = resourceHolder;
                }
                resourceHolderToUse.addConnection(connection);
            }
            if (channel2 == null) {
                channel2 = resourceFactory.createChannel(connection);
            }
            resourceHolderToUse.addChannel(channel2, connection);
            if (!resourceHolderToUse.equals(resourceHolder)) {
                ConnectionFactoryUtils.bindResourceToTransaction(resourceHolderToUse, connectionFactory, resourceFactory.isSynchedLocalTransactionAllowed());
            }
            return resourceHolderToUse;
        }
        catch (IOException ex) {
            RabbitUtils.closeConnection(connection);
            throw new AmqpIOException(ex);
        }
    }

    public static void releaseResources(@Nullable RabbitResourceHolder resourceHolder) {
        if (resourceHolder == null || resourceHolder.isSynchronizedWithTransaction()) {
            return;
        }
        RabbitUtils.closeChannel(resourceHolder.getChannel());
        RabbitUtils.closeConnection(resourceHolder.getConnection());
    }

    public static RabbitResourceHolder bindResourceToTransaction(RabbitResourceHolder resourceHolder, ConnectionFactory connectionFactory, boolean synched) {
        if (TransactionSynchronizationManager.hasResource(connectionFactory) || !TransactionSynchronizationManager.isActualTransactionActive() || !synched) {
            return (RabbitResourceHolder)TransactionSynchronizationManager.getResource(connectionFactory);
        }
        TransactionSynchronizationManager.bindResource(connectionFactory, resourceHolder);
        resourceHolder.setSynchronizedWithTransaction(true);
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization(new RabbitResourceSynchronization(resourceHolder, connectionFactory));
        }
        return resourceHolder;
    }

    public static void registerDeliveryTag(ConnectionFactory connectionFactory, Channel channel, Long tag) {
        Assert.notNull((Object)connectionFactory, "ConnectionFactory must not be null");
        RabbitResourceHolder resourceHolder = (RabbitResourceHolder)TransactionSynchronizationManager.getResource(connectionFactory);
        if (resourceHolder != null) {
            resourceHolder.addDeliveryTag(channel, tag);
        }
    }

    public static Connection createConnection(ConnectionFactory connectionFactory, boolean publisherConnectionIfPossible) {
        ConnectionFactory publisherFactory;
        if (publisherConnectionIfPossible && (publisherFactory = connectionFactory.getPublisherConnectionFactory()) != null) {
            return publisherFactory.createConnection();
        }
        return connectionFactory.createConnection();
    }

    private static final class RabbitResourceSynchronization
    extends ResourceHolderSynchronization<RabbitResourceHolder, Object> {
        private final RabbitResourceHolder resourceHolder;

        RabbitResourceSynchronization(RabbitResourceHolder resourceHolder, Object resourceKey) {
            super(resourceHolder, resourceKey);
            this.resourceHolder = resourceHolder;
        }

        @Override
        protected boolean shouldReleaseBeforeCompletion() {
            return false;
        }

        @Override
        public void afterCompletion(int status) {
            if (status == 0) {
                this.resourceHolder.commitAll();
            } else {
                this.resourceHolder.rollbackAll();
            }
            if (this.resourceHolder.isReleaseAfterCompletion()) {
                this.resourceHolder.setSynchronizedWithTransaction(false);
            }
            super.afterCompletion(status);
        }

        @Override
        protected void releaseResource(RabbitResourceHolder resourceHolder, Object resourceKey) {
            ConnectionFactoryUtils.releaseResources(resourceHolder);
        }
    }

    private static class RabbitResourceFactory
    implements ResourceFactory {
        private final ConnectionFactory connectionFactory;
        private final boolean synchedLocalTransactionAllowed;
        private final boolean publisherConnectionIfPossible;

        RabbitResourceFactory(ConnectionFactory connectionFactory, boolean synchedLocalTransactionAllowed, boolean publisherConnectionIfPossible) {
            this.connectionFactory = connectionFactory;
            this.synchedLocalTransactionAllowed = synchedLocalTransactionAllowed;
            this.publisherConnectionIfPossible = publisherConnectionIfPossible;
        }

        @Override
        @Nullable
        public Channel getChannel(RabbitResourceHolder holder) {
            return holder.getChannel();
        }

        @Override
        @Nullable
        public Connection getConnection(RabbitResourceHolder holder) {
            return holder.getConnection();
        }

        @Override
        public Connection createConnection() {
            return ConnectionFactoryUtils.createConnection(this.connectionFactory, this.publisherConnectionIfPossible);
        }

        @Override
        public Channel createChannel(Connection con) {
            return con.createChannel(this.synchedLocalTransactionAllowed);
        }

        @Override
        public boolean isSynchedLocalTransactionAllowed() {
            return this.synchedLocalTransactionAllowed;
        }
    }

    public static interface ResourceFactory {
        @Nullable
        public Channel getChannel(RabbitResourceHolder var1);

        public Connection getConnection(RabbitResourceHolder var1);

        public Connection createConnection() throws IOException;

        public Channel createChannel(Connection var1) throws IOException;

        public boolean isSynchedLocalTransactionAllowed();
    }
}

