/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.event.AmqpEvent;
import org.springframework.util.Assert;

public class BrokerEvent
extends AmqpEvent {
    private final MessageProperties properties;

    public BrokerEvent(Object source, MessageProperties properties) {
        super(source);
        Assert.notNull((Object)properties, "MessageProperties cannot be null");
        this.properties = properties;
    }

    public String getEventType() {
        return this.properties.getReceivedRoutingKey();
    }

    public Map<String, Object> getEventProperties() {
        return this.properties.getHeaders();
    }

    public MessageProperties getMessageProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "BrokerEvent [eventType=" + this.getEventType() + ", properties=" + this.getEventProperties() + "]";
    }
}

