/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.amqp;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ConnectionFactory;
import java.time.Duration;
import java.util.stream.Collectors;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitMessagingTemplate;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.autoconfigure.amqp.RabbitRetryTemplateCustomizer;
import org.springframework.boot.autoconfigure.amqp.RetryTemplateFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RabbitTemplate.class, Channel.class})
@EnableConfigurationProperties(value={RabbitProperties.class})
@Import(value={RabbitAnnotationDrivenConfiguration.class})
public class RabbitAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RabbitMessagingTemplate.class})
    @ConditionalOnMissingBean(value={RabbitMessagingTemplate.class})
    @Import(value={RabbitTemplateConfiguration.class})
    protected static class MessagingTemplateConfiguration {
        protected MessagingTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=RabbitTemplate.class)
        public RabbitMessagingTemplate rabbitMessagingTemplate(RabbitTemplate rabbitTemplate) {
            return new RabbitMessagingTemplate(rabbitTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={RabbitConnectionFactoryCreator.class})
    protected static class RabbitTemplateConfiguration {
        protected RabbitTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnMissingBean(value={RabbitOperations.class})
        public RabbitTemplate rabbitTemplate(RabbitProperties properties, ObjectProvider<MessageConverter> messageConverter, ObjectProvider<RabbitRetryTemplateCustomizer> retryTemplateCustomizers, org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            PropertyMapper map = PropertyMapper.get();
            RabbitTemplate template = new RabbitTemplate(connectionFactory);
            messageConverter.ifUnique(template::setMessageConverter);
            template.setMandatory(this.determineMandatoryFlag(properties));
            RabbitProperties.Template templateProperties = properties.getTemplate();
            if (templateProperties.getRetry().isEnabled()) {
                template.setRetryTemplate(new RetryTemplateFactory(retryTemplateCustomizers.orderedStream().collect(Collectors.toList())).createRetryTemplate(templateProperties.getRetry(), RabbitRetryTemplateCustomizer.Target.SENDER));
            }
            map.from(templateProperties::getReceiveTimeout).whenNonNull().as(Duration::toMillis).to(template::setReceiveTimeout);
            map.from(templateProperties::getReplyTimeout).whenNonNull().as(Duration::toMillis).to(template::setReplyTimeout);
            map.from(templateProperties::getExchange).to(template::setExchange);
            map.from(templateProperties::getRoutingKey).to(template::setRoutingKey);
            map.from(templateProperties::getDefaultReceiveQueue).whenNonNull().to(template::setDefaultReceiveQueue);
            return template;
        }

        private boolean determineMandatoryFlag(RabbitProperties properties) {
            Boolean mandatory = properties.getTemplate().getMandatory();
            return mandatory != null ? mandatory.booleanValue() : properties.isPublisherReturns();
        }

        @Bean
        @ConditionalOnSingleCandidate(value=org.springframework.amqp.rabbit.connection.ConnectionFactory.class)
        @ConditionalOnProperty(prefix="spring.rabbitmq", name={"dynamic"}, matchIfMissing=true)
        @ConditionalOnMissingBean
        public AmqpAdmin amqpAdmin(org.springframework.amqp.rabbit.connection.ConnectionFactory connectionFactory) {
            return new RabbitAdmin(connectionFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnMissingBean(value={org.springframework.amqp.rabbit.connection.ConnectionFactory.class})
    protected static class RabbitConnectionFactoryCreator {
        protected RabbitConnectionFactoryCreator() {
        }

        @Bean
        public CachingConnectionFactory rabbitConnectionFactory(RabbitProperties properties, ObjectProvider<ConnectionNameStrategy> connectionNameStrategy) throws Exception {
            PropertyMapper map = PropertyMapper.get();
            CachingConnectionFactory factory = new CachingConnectionFactory((ConnectionFactory)this.getRabbitConnectionFactoryBean(properties).getObject());
            map.from(properties::determineAddresses).to(factory::setAddresses);
            map.from(properties::isPublisherReturns).to(factory::setPublisherReturns);
            map.from(properties::getPublisherConfirmType).whenNonNull().to(factory::setPublisherConfirmType);
            RabbitProperties.Cache.Channel channel = properties.getCache().getChannel();
            map.from(channel::getSize).whenNonNull().to(factory::setChannelCacheSize);
            map.from(channel::getCheckoutTimeout).whenNonNull().as(Duration::toMillis).to(factory::setChannelCheckoutTimeout);
            RabbitProperties.Cache.Connection connection = properties.getCache().getConnection();
            map.from(connection::getMode).whenNonNull().to(factory::setCacheMode);
            map.from(connection::getSize).whenNonNull().to(factory::setConnectionCacheSize);
            map.from(connectionNameStrategy::getIfUnique).whenNonNull().to(factory::setConnectionNameStrategy);
            return factory;
        }

        private RabbitConnectionFactoryBean getRabbitConnectionFactoryBean(RabbitProperties properties) throws Exception {
            PropertyMapper map = PropertyMapper.get();
            RabbitConnectionFactoryBean factory = new RabbitConnectionFactoryBean();
            map.from(properties::determineHost).whenNonNull().to(factory::setHost);
            map.from(properties::determinePort).to(factory::setPort);
            map.from(properties::determineUsername).whenNonNull().to(factory::setUsername);
            map.from(properties::determinePassword).whenNonNull().to(factory::setPassword);
            map.from(properties::determineVirtualHost).whenNonNull().to(factory::setVirtualHost);
            map.from(properties::getRequestedHeartbeat).whenNonNull().asInt(Duration::getSeconds).to(factory::setRequestedHeartbeat);
            RabbitProperties.Ssl ssl = properties.getSsl();
            if (ssl.determineEnabled()) {
                factory.setUseSSL(true);
                map.from(ssl::getAlgorithm).whenNonNull().to(factory::setSslAlgorithm);
                map.from(ssl::getKeyStoreType).to(factory::setKeyStoreType);
                map.from(ssl::getKeyStore).to(factory::setKeyStore);
                map.from(ssl::getKeyStorePassword).to(factory::setKeyStorePassphrase);
                map.from(ssl::getTrustStoreType).to(factory::setTrustStoreType);
                map.from(ssl::getTrustStore).to(factory::setTrustStore);
                map.from(ssl::getTrustStorePassword).to(factory::setTrustStorePassphrase);
                map.from(ssl::isValidateServerCertificate).to(validate -> factory.setSkipServerCertificateValidation(validate == false));
                map.from(ssl::getVerifyHostname).to(factory::setEnableHostnameVerification);
            }
            map.from(properties::getConnectionTimeout).whenNonNull().asInt(Duration::toMillis).to(factory::setConnectionTimeout);
            factory.afterPropertiesSet();
            return factory;
        }
    }
}

