/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import springfox.documentation.builders.EncodingBuilder;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.service.Encoding;
import springfox.documentation.service.Representation;

public class RepresentationBuilder {
    private MediaType mediaType;
    private ModelSpecificationBuilder modelBuilder;
    private final Map<String, EncodingBuilder> encodings = new HashMap<String, EncodingBuilder>();

    private ModelSpecificationBuilder modelSpecificationBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = new ModelSpecificationBuilder();
        }
        return this.modelBuilder;
    }

    public RepresentationBuilder model(Consumer<ModelSpecificationBuilder> model) {
        model.accept(this.modelSpecificationBuilder());
        return this;
    }

    public RepresentationBuilder mediaType(String mediaType) {
        this.mediaType = MediaType.parseMediaType(mediaType);
        return this;
    }

    public RepresentationBuilder mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public RepresentationBuilder clearEncodings() {
        this.encodings.clear();
        return this;
    }

    private EncodingBuilder encodingForProperty(String property) {
        return this.encodings.computeIfAbsent(property, p -> new EncodingBuilder().propertyRef((String)p));
    }

    public Function<Consumer<EncodingBuilder>, RepresentationBuilder> encoding(String property) {
        return encoding -> {
            encoding.accept(this.encodingForProperty(property));
            return this;
        };
    }

    public Representation build() {
        return new Representation(this.mediaType, this.modelBuilder.build(), this.encodings.values().stream().map(EncodingBuilder::build).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public RepresentationBuilder copyOf(Representation other) {
        if (other != null) {
            other.getEncodings().forEach(e -> this.encoding(e.getPropertyRef()).apply(encoding -> encoding.copyOf((Encoding)e)));
            this.mediaType(other.getMediaType()).model(m -> m.copyOf(other.getModel()));
        }
        return this;
    }
}

