/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.web;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.adapter.ForwardedHeaderTransformer;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.SpecGeneration;
import springfox.documentation.oas.web.WebFluxOpenApiTransformationFilter;
import springfox.documentation.spi.DocumentationType;

@Order(value=-2147483648)
public class WebFluxBasePathAndHostnameTransformationFilter
implements WebFluxOpenApiTransformationFilter {
    private final String requestPrefix;

    public WebFluxBasePathAndHostnameTransformationFilter(@Value(value="${springfox.documentation.open-api.v3.path:/v3/api-docs}") String oasPath) {
        this.requestPrefix = StringUtils.trimTrailingCharacter(oasPath, '/');
    }

    @Override
    public OpenAPI transform(OpenApiTransformationContext<ServerHttpRequest> context) {
        OpenAPI openApi = context.getSpecification();
        context.request().ifPresent(request -> {
            String requestUrl = this.decode(new ForwardedHeaderTransformer().apply((ServerHttpRequest)request).getURI().toString());
            openApi.servers(Collections.singletonList(SpecGeneration.inferredServer(this.requestPrefix, requestUrl)));
        });
        return openApi;
    }

    protected String decode(String requestURI) {
        try {
            return URLDecoder.decode(requestURI, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return requestURI;
        }
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.OAS_30;
    }
}

