/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.service;

import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;

public class MediaTypes {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTypes.class);

    private MediaTypes() {
        throw new UnsupportedOperationException();
    }

    public static Set<MediaType> toMediaTypes(Set<String> consumes) {
        return consumes.stream().map(MediaTypes.parsedMediaType()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Function<String, MediaType> parsedMediaType() {
        return new Function<String, MediaType>(){

            @Override
            public MediaType apply(String input) {
                try {
                    return MediaType.valueOf(input);
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Unable to parse media type %s", input));
                    return null;
                }
            }
        };
    }
}

