/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.paths;

import org.springframework.web.util.UriComponentsBuilder;
import springfox.documentation.PathProvider;
import springfox.documentation.spring.web.paths.Paths;

public class DefaultPathProvider
implements PathProvider {
    protected String getDocumentationPath() {
        return "/";
    }

    @Override
    public String getOperationPath(String operationPath) {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath("/");
        return Paths.removeAdjacentForwardSlashes(uriComponentsBuilder.path(operationPath).build().toString());
    }

    @Override
    public String getResourceListingPath(String groupName, String apiDeclaration) {
        String candidate = this.agnosticUriComponentBuilder(this.getDocumentationPath()).pathSegment(groupName, apiDeclaration).build().toString();
        return Paths.removeAdjacentForwardSlashes(candidate);
    }

    private UriComponentsBuilder agnosticUriComponentBuilder(String url) {
        UriComponentsBuilder uriComponentsBuilder = url.startsWith("http") ? UriComponentsBuilder.fromHttpUrl(url) : UriComponentsBuilder.fromPath(url);
        return uriComponentsBuilder;
    }
}

