/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.plugins;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.PathProvider;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.AlternateTypeRule;
import springfox.documentation.schema.AlternateTypeRules;
import springfox.documentation.schema.CodeGenGenericTypeNamingStrategy;
import springfox.documentation.schema.DefaultGenericTypeNamingStrategy;
import springfox.documentation.schema.WildcardType;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListingReference;
import springfox.documentation.service.Operation;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.Response;
import springfox.documentation.service.ResponseMessage;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.service.Server;
import springfox.documentation.service.Tag;
import springfox.documentation.service.VendorExtension;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.GenericTypeNamingStrategy;
import springfox.documentation.spi.service.DocumentationPlugin;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.DocumentationContextBuilder;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;

public class Docket
implements DocumentationPlugin {
    public static final String DEFAULT_GROUP_NAME = "default";
    private final DocumentationType documentationType;
    private final List<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
    private final Map<RequestMethod, List<ResponseMessage>> responseMessages = new HashMap<RequestMethod, List<ResponseMessage>>();
    private final Map<HttpMethod, List<Response>> responses = new HashMap<HttpMethod, List<Response>>();
    private final List<Parameter> globalOperationParameters = new ArrayList<Parameter>();
    private final List<Function<TypeResolver, AlternateTypeRule>> ruleBuilders = new ArrayList<Function<TypeResolver, AlternateTypeRule>>();
    private final Set<Class> ignorableParameterTypes = new HashSet<Class>();
    private final Set<String> protocols = new HashSet<String>();
    private final Set<String> produces = new LinkedHashSet<String>();
    private final Set<String> consumes = new LinkedHashSet<String>();
    private final Set<ResolvedType> additionalModels = new HashSet<ResolvedType>();
    private final Set<Tag> tags = new HashSet<Tag>();
    private final List<Server> servers = new ArrayList<Server>();
    private PathProvider pathProvider;
    private List<SecurityScheme> securitySchemes;
    private Comparator<ApiListingReference> apiListingReferenceOrdering;
    private Comparator<ApiDescription> apiDescriptionOrdering;
    private Comparator<Operation> operationOrdering;
    private ApiInfo apiInfo = ApiInfo.DEFAULT;
    private String groupName = "default";
    private boolean enabled = true;
    private GenericTypeNamingStrategy genericsNamingStrategy = new DefaultGenericTypeNamingStrategy();
    private boolean applyDefaultResponseMessages = true;
    private String host = "";
    private Optional<String> pathMapping = Optional.empty();
    private ApiSelector apiSelector = ApiSelector.DEFAULT;
    private boolean enableUrlTemplating = false;
    private final List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();
    private final List<RequestParameter> globalRequestParameters = new ArrayList<RequestParameter>();

    public Docket(DocumentationType documentationType) {
        this.documentationType = documentationType;
    }

    public Docket extensions(List<VendorExtension> vendorExtensions) {
        this.vendorExtensions.addAll(vendorExtensions);
        return this;
    }

    public Docket apiInfo(ApiInfo apiInfo) {
        this.apiInfo = BuilderDefaults.defaultIfAbsent(apiInfo, this.apiInfo);
        return this;
    }

    public Docket securitySchemes(List<SecurityScheme> securitySchemes) {
        this.securitySchemes = securitySchemes;
        return this;
    }

    public Docket securityContexts(List<SecurityContext> securityContexts) {
        this.securityContexts.addAll(securityContexts);
        return this;
    }

    public Docket groupName(String groupName) {
        this.groupName = BuilderDefaults.defaultIfAbsent(groupName, this.groupName);
        return this;
    }

    public Docket pathProvider(PathProvider pathProvider) {
        this.pathProvider = pathProvider;
        return this;
    }

    @Deprecated
    public Docket globalResponseMessage(RequestMethod requestMethod, List<ResponseMessage> responseMessages) {
        this.responseMessages.put(requestMethod, responseMessages);
        return this;
    }

    public Docket globalResponses(HttpMethod httpMethod, List<Response> responses) {
        this.responses.put(httpMethod, responses);
        return this;
    }

    @Deprecated
    public Docket globalOperationParameters(List<Parameter> operationParameters) {
        this.globalOperationParameters.addAll(BuilderDefaults.nullToEmptyList(operationParameters));
        return this;
    }

    public Docket globalRequestParameters(List<RequestParameter> globalRequestParameters) {
        this.globalRequestParameters.addAll(BuilderDefaults.nullToEmptyList(globalRequestParameters));
        return this;
    }

    public Docket ignoredParameterTypes(Class ... classes) {
        this.ignorableParameterTypes.addAll(Arrays.asList(classes));
        return this;
    }

    public Docket produces(Set<String> produces) {
        this.produces.addAll(produces);
        return this;
    }

    public Docket consumes(Set<String> consumes) {
        this.consumes.addAll(consumes);
        return this;
    }

    @Incubating(value="2.3")
    public Docket host(String host) {
        this.host = BuilderDefaults.defaultIfAbsent(host, this.host);
        return this;
    }

    public Docket protocols(Set<String> protocols) {
        this.protocols.addAll(protocols);
        return this;
    }

    public Docket alternateTypeRules(AlternateTypeRule ... alternateTypeRules) {
        this.ruleBuilders.addAll(Stream.of(alternateTypeRules).map(this.identityRuleBuilder()).collect(Collectors.toList()));
        return this;
    }

    public Docket operationOrdering(Comparator<Operation> operationOrdering) {
        this.operationOrdering = operationOrdering;
        return this;
    }

    public Docket directModelSubstitute(Class clazz, Class with) {
        this.ruleBuilders.add(this.newSubstitutionFunction(clazz, with));
        return this;
    }

    public Docket genericModelSubstitutes(Class ... genericClasses) {
        for (Class clz : genericClasses) {
            this.ruleBuilders.add(this.newGenericSubstitutionFunction(clz));
        }
        return this;
    }

    public Docket useDefaultResponseMessages(boolean apply) {
        this.applyDefaultResponseMessages = apply;
        return this;
    }

    public Docket apiListingReferenceOrdering(Comparator<ApiListingReference> apiListingReferenceOrdering) {
        this.apiListingReferenceOrdering = apiListingReferenceOrdering;
        return this;
    }

    public Docket apiDescriptionOrdering(Comparator<ApiDescription> apiDescriptionOrdering) {
        this.apiDescriptionOrdering = apiDescriptionOrdering;
        return this;
    }

    public Docket enable(boolean externallyConfiguredFlag) {
        this.enabled = externallyConfiguredFlag;
        return this;
    }

    public Docket forCodeGeneration(boolean forCodeGen) {
        if (forCodeGen) {
            this.genericsNamingStrategy = new CodeGenGenericTypeNamingStrategy();
        }
        return this;
    }

    public Docket pathMapping(String path) {
        this.pathMapping = Optional.ofNullable(path);
        return this;
    }

    @Incubating(value="2.1.0")
    public Docket enableUrlTemplating(boolean enabled) {
        this.enableUrlTemplating = enabled;
        return this;
    }

    public Docket additionalModels(ResolvedType first, ResolvedType ... remaining) {
        this.additionalModels.add(first);
        this.additionalModels.addAll(Arrays.stream(remaining).collect(Collectors.toSet()));
        return this;
    }

    public Docket tags(Tag first, Tag ... remaining) {
        this.tags.add(first);
        this.tags.addAll(Arrays.stream(remaining).collect(Collectors.toSet()));
        return this;
    }

    public Docket servers(Server first, Server ... remaining) {
        this.servers.add(first);
        this.servers.addAll(Arrays.stream(BuilderDefaults.nullToEmptyArray(remaining)).collect(Collectors.toSet()));
        return this;
    }

    public ApiSelectorBuilder select() {
        return new ApiSelectorBuilder(this);
    }

    @Override
    public DocumentationContext configure(DocumentationContextBuilder builder) {
        return builder.apiInfo(this.apiInfo).selector(this.apiSelector).applyDefaultResponseMessages(this.applyDefaultResponseMessages).additionalResponseMessages(this.responseMessages).additionalResponses(this.responses).additionalOperationParameters(this.globalOperationParameters).additionalRequestParameters(this.globalRequestParameters).additionalIgnorableTypes(this.ignorableParameterTypes).ruleBuilders(this.ruleBuilders).groupName(this.groupName).pathProvider(this.pathProvider).securityContexts(this.securityContexts).securitySchemes(this.securitySchemes).apiListingReferenceOrdering(this.apiListingReferenceOrdering).apiDescriptionOrdering(this.apiDescriptionOrdering).operationOrdering(this.operationOrdering).produces(this.produces).consumes(this.consumes).host(this.host).protocols(this.protocols).genericsNaming(this.genericsNamingStrategy).pathMapping(this.pathMapping).enableUrlTemplating(this.enableUrlTemplating).additionalModels(this.additionalModels).tags(this.tags).vendorExtentions(this.vendorExtensions).servers(this.servers).build();
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public DocumentationType getDocumentationType() {
        return this.documentationType;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return this.documentationType.equals(delimiter);
    }

    private Function<AlternateTypeRule, Function<TypeResolver, AlternateTypeRule>> identityRuleBuilder() {
        return this::identityFunction;
    }

    private Function<TypeResolver, AlternateTypeRule> identityFunction(AlternateTypeRule rule) {
        return typeResolver -> rule;
    }

    Docket selector(ApiSelector apiSelector) {
        this.apiSelector = apiSelector;
        return this;
    }

    private Function<TypeResolver, AlternateTypeRule> newSubstitutionFunction(Class clazz, Class with) {
        return typeResolver -> AlternateTypeRules.newRule(typeResolver.resolve(clazz, new Type[0]), typeResolver.resolve(with, new Type[0]), -2147480648);
    }

    private Function<TypeResolver, AlternateTypeRule> newGenericSubstitutionFunction(Class clz) {
        return typeResolver -> AlternateTypeRules.newRule(typeResolver.resolve(clz, new Type[]{WildcardType.class}), typeResolver.resolve((Type)((Object)WildcardType.class), new Type[0]), -2147481648);
    }
}

