package com.aiup.api.controller;


import com.aiup.service.domain.R;
import com.aiup.service.domain.query.ConfigListQuery;
import com.aiup.service.domain.query.IdQuery;
import com.aiup.service.domain.query.NoteTaskListQuery;
import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.NoteTaskDistributionResponse;
import com.aiup.service.entity.UserConfig;
import com.aiup.service.entity.UserNotesTask;
import com.aiup.service.service.UserConfigService;
import com.aiup.service.service.UserNotesTaskService;
import com.aiup.service.utils.LoginUserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.List;

@Api(tags = "任务相关接口")
@RestController
@RequestMapping("/v1/task")
@RequiredArgsConstructor
public class NoteTaskController {

    @Autowired
    private UserNotesTaskService userNotesTaskService;

    @ApiOperation(value = "获取任务列表")
    @PostMapping("/getTaskList")
    public R<List<UserNotesTask>> getListByUser(@RequestBody @Validated NoteTaskListQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        List<UserNotesTask> list = userNotesTaskService.getListByUser(query);
        return R.ok(list);
    }




    @ApiOperation(value = "获取任务详情")
    @PostMapping("/getDetail")
    public R<UserNotesTask> getDetail(@RequestBody IdQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        PageRequest pageRequest = PageRequest.of(0,200);
        UserNotesTask templateInfo = new UserNotesTask();
        templateInfo.setUserId(query.getUserId());
        templateInfo.setId(query.getRecordId());
        List<UserNotesTask> list = userNotesTaskService.queryByPage(templateInfo, pageRequest).getContent();
        if(list == null || list.size()<=0){
            return R.error("任务不存在");
        }
        UserNotesTask temp = list.get(0);
        return R.ok(temp);
    }


    @ApiOperation(value = "获取一段时间内任务分布")
    @PostMapping("/getTaskDistribution")
    public R<List<NoteTaskDistributionResponse>> getTaskDistribution(@RequestBody @Validated NoteTaskListQuery query) {
        query.setUserId(LoginUserUtils.getLoginUser().getUserId());
        List<NoteTaskDistributionResponse> list = userNotesTaskService.getTaskDistribution(query);
        return R.ok(list);
    }

}
