package com.aiup.api.controller;


import com.aiup.service.domain.R;
import com.aiup.service.domain.openai.ChatResponse;
import com.aiup.service.domain.query.GptChatQuery;
import com.aiup.service.domain.query.PrePayQuery;
import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.GptChatResponse;
import com.aiup.service.domain.response.OrderListResponse;
import com.aiup.service.domain.response.WxPrePayResponse;
import com.aiup.service.entity.UserInfo;
import com.aiup.service.service.OpenAiService;
import com.aiup.service.service.WxPayService;
import com.aiup.service.utils.LoginUserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.List;

@Api(tags = "支付相关接口")
@RestController
@RequestMapping("/v1/pay")
@RequiredArgsConstructor
public class PayController {

    @Autowired
    private WxPayService wxPayService;

    @ApiOperation(value = "创建支付单")
    @PostMapping("/createPrePayOrder")
    public R<WxPrePayResponse> createPrePayOrder(@RequestBody @Valid PrePayQuery query) {
        UserInfo loginUser = LoginUserUtils.getLoginUser();
        // 只能给自己发起支付单
        query.setUserId(loginUser.getUserId());
        return R.ok(wxPayService.prePay(query));
    }

    @ApiOperation(value = "支付是否成功")
    @PostMapping("/isPay")
    public R<Boolean> getIsPay(@RequestBody @Valid WxPrePayResponse query) {
        UserInfo loginUser = LoginUserUtils.getLoginUser();
        query.setUserId(loginUser.getUserId());
        return R.ok(wxPayService.getIsPay(query));
    }


    @ApiOperation(value = "获取订单列表")
    @PostMapping("/getOrderList")
    public R<List<OrderListResponse>> getOrderList(@RequestBody UserInfoQuery query) {
        UserInfo loginUser = LoginUserUtils.getLoginUser();
        query.setUserId(loginUser.getUserId());
        List<OrderListResponse> list = wxPayService.getOrderList(query);
        return R.ok(list);
    }
}
