/**
 * yichehuoban.cn
 * Copyright (C) 2004-2018 All Rights Reserved.
 */
package com.aiup.service.config.exception;

import lombok.Data;

/**
 * @author wangzhiyuan
 */
@Data
public class PageException extends RuntimeException {
    private static final long serialVersionUID = 1L;

    private int code = -1;

    private Object msg;
    // 页面路径
    private String page;


    public PageException(String page) {
        this.page = page;
    }

    public PageException(Object msg, String page) {
        this.msg = msg;
        this.page = page;
    }

    public PageException(Throwable e) {
        super(e);
    }

    public PageException(String msg, Throwable e) {
        super(msg, e);
        this.msg = msg;
    }

    public PageException(String msg, int code) {
        super(msg);
        this.msg = msg;
        this.code = code;
    }

    public PageException(String msg, int code, Throwable e) {
        super(msg, e);
        this.msg = msg;
        this.code = code;
    }

}
