package com.aiup.service.dao;

import com.aiup.service.domain.query.ConfigListQuery;
import com.aiup.service.entity.UserConfig;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Pageable;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;

/**
 * 用户配置信息(UserConfig)表数据库访问层
 *
 * @author makejava
 * @since 2023-08-29 16:49:46
 */
@Mapper
public interface UserConfigDao {

    /**
     * 通过ID查询单条数据
     *
     * @param configId 主键
     * @return 实例对象
     */
    UserConfig queryById(Integer configId);

    /**
     * 查询指定行数据
     *
     * @param userConfig 查询条件
     * @param pageable   分页对象
     * @return 对象列表
     */
    List<UserConfig> queryAllByLimit(@Param("bean") UserConfig userConfig, @Param("pageable") Pageable pageable);

    /**
     * 统计总行数
     *
     * @param userConfig 查询条件
     * @return 总行数
     */
    long count(UserConfig userConfig);

    /**
     * 新增数据
     *
     * @param userConfig 实例对象
     * @return 影响行数
     */
    int insert(UserConfig userConfig);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserConfig> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<UserConfig> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<UserConfig> 实例对象列表
     * @return 影响行数
     * @throws org.springframework.jdbc.BadSqlGrammarException 入参是空List的时候会抛SQL语句错误的异常，请自行校验入参
     */
    int insertOrUpdateBatch(@Param("entities") List<UserConfig> entities);

    /**
     * 修改数据
     *
     * @param userConfig 实例对象
     * @return 影响行数
     */
    int update(UserConfig userConfig);

    /**
     * 通过主键删除数据
     *
     * @param configId 主键
     * @return 影响行数
     */
    int deleteById(Integer configId);

    List<UserConfig> getListByType(ConfigListQuery query);
}

