package com.aiup.service.domain.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

@ApiModel("微信登录请求对象")
@Data
public class WeChatGetMobileQuery {

    @NotNull(message = "sessionKey不能为空")
    @ApiModelProperty(value = "sessionKey", required = true)
    private String sessionKey;

    @ApiModelProperty(value = "用户非敏感字段")
    private String rawData;
    @ApiModelProperty(value = "签名")
    private String signature;
    @ApiModelProperty(value = "用户敏感字段")
    private String encryptedData;
    @ApiModelProperty(value = "解密向量")
    private String iv;
    @ApiModelProperty(value = "登录用户ID（前端不用传）",hidden = true)
    private Integer userId;

}
