package com.aiup.service.entity;

import java.util.Date;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品支付单(PrepayOrder)实体类
 *
 * @author makejava
 * @since 2023-08-22 12:54:39
 */

@ApiModel("商品支付单")
public class PrepayOrder implements Serializable {
    private static final long serialVersionUID = 368522087992501579L;
    /**
     * ID
     */    
    @ApiModelProperty(value = "ID")
    private Integer id;
    /**
     * 用户ID
     */    
    @ApiModelProperty(value = "用户ID")
    private Integer userId;
    /**
     * 商品ID
     */    
    @ApiModelProperty(value = "商品ID")
    private Integer productId;
    /**
     * 商品数量
     */    
    @ApiModelProperty(value = "商品数量")
    private Integer productTotal;
    /**
     * 商品单价
     */    
    @ApiModelProperty(value = "商品单价")
    private Double amount;
    /**
     * 商品总价
     */    
    @ApiModelProperty(value = "商品总价")
    private Double totalAmount;
    /**
     * 支付APPID
     */    
    @ApiModelProperty(value = "支付APPID")
    private String appId;
    /**
     * 商户号
     */    
    @ApiModelProperty(value = "商户号")
    private String mchId;
    /**
     * 备注
     */    
    @ApiModelProperty(value = "备注")
    private String description;
    /**
     * 回调url地址
     */    
    @ApiModelProperty(value = "回调url地址")
    private String notifyUrl;
    /**
     * 流水号
     */    
    @ApiModelProperty(value = "流水号")
    private String outTradeNo;
    /**
     * 预支付交易会话标识	
     */    
    @ApiModelProperty(value = "预支付交易会话标识	")
    private String prepayId;
    /**
     * 支付平台返回流水号
     */    
    @ApiModelProperty(value = "支付平台返回流水号")
    private String transactionId;
    /**
     * 创建时间
     */    
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 是否删除
     */    
    @ApiModelProperty(value = "是否删除")
    private Integer isDeleted;
    /**
     * 是否付款
     */    
    @ApiModelProperty(value = "是否付款")
    private Integer isPay;
    /**
     * 付款时间
     */    
    @ApiModelProperty(value = "付款时间")
    private Date payTime;
    /**
     * 修改时间
     */    
    @ApiModelProperty(value = "修改时间")
    private Date updateTime;


    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Integer getProductId() {
        return productId;
    }

    public void setProductId(Integer productId) {
        this.productId = productId;
    }

    public Integer getProductTotal() {
        return productTotal;
    }

    public void setProductTotal(Integer productTotal) {
        this.productTotal = productTotal;
    }

    public Double getAmount() {
        return amount;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMchId() {
        return mchId;
    }

    public void setMchId(String mchId) {
        this.mchId = mchId;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getIsDeleted() {
        return isDeleted;
    }

    public void setIsDeleted(Integer isDeleted) {
        this.isDeleted = isDeleted;
    }

    public Integer getIsPay() {
        return isPay;
    }

    public void setIsPay(Integer isPay) {
        this.isPay = isPay;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

}

