package com.aiup.service.service;

import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.OrderListResponse;
import com.aiup.service.entity.PrepayOrder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import java.util.List;

/**
 * 商品支付单(PrepayOrder)表服务接口
 *
 * @author makejava
 * @since 2023-08-08 14:57:58
 */
public interface PrepayOrderService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    PrepayOrder queryById(Integer id);

    /**
     * 分页查询
     *
     * @param prepayOrder 筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    Page<PrepayOrder> queryByPage(PrepayOrder prepayOrder, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param prepayOrder 实例对象
     * @return 实例对象
     */
    PrepayOrder insert(PrepayOrder prepayOrder);

    /**
     * 修改数据
     *
     * @param prepayOrder 实例对象
     * @return 实例对象
     */
    PrepayOrder update(PrepayOrder prepayOrder);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Integer id);

    List<OrderListResponse> getOrderList(UserInfoQuery query);
}
