package com.aiup.service.service;

import com.aiup.service.domain.query.NoteTaskListQuery;
import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.NoteTaskDistributionResponse;
import com.aiup.service.entity.UserNotesTask;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;

import java.util.List;

/**
 * 用户任务队列(UserNotesTask)表服务接口
 *
 * @author makejava
 * @since 2023-08-28 16:50:23
 */
public interface UserNotesTaskService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    UserNotesTask queryById(Integer id);

    /**
     * 分页查询
     *
     * @param userNotesTask 筛选条件
     * @param pageRequest   分页对象
     * @return 查询结果
     */
    Page<UserNotesTask> queryByPage(UserNotesTask userNotesTask, PageRequest pageRequest);

    /**
     * 新增数据
     *
     * @param userNotesTask 实例对象
     * @return 实例对象
     */
    UserNotesTask insert(UserNotesTask userNotesTask);

    /**
     * 修改数据
     *
     * @param userNotesTask 实例对象
     * @return 实例对象
     */
    UserNotesTask update(UserNotesTask userNotesTask);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    boolean deleteById(Integer id);

    List<UserNotesTask> getListByUser(NoteTaskListQuery query);


    List<NoteTaskDistributionResponse> getTaskDistribution(NoteTaskListQuery query);
}
