package com.aiup.service.service;

import com.aiup.service.domain.query.PrePayQuery;
import com.aiup.service.domain.query.ProductListQuery;
import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.OrderListResponse;
import com.aiup.service.domain.response.ProductListResponse;
import com.aiup.service.domain.response.WxPrePayResponse;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 微信支付相关逻辑
 */
public interface WxPayService {
    /**
     * 发起支付请求
     * @param query 支付对象
     * @return
     */
    WxPrePayResponse prePay(PrePayQuery query);

    /**
     * 获取商品列表
     * @param query
     * @return
     */
    List<ProductListResponse> getProductList(ProductListQuery query);

    /**
     * 支付是否成功
     * @param query
     * @return
     */
    Boolean getIsPay(WxPrePayResponse query);

    /**
     * 微信支付回调
     * @param request
     * @param response
     * @return
     */
    Map<String, Object> payNotify(HttpServletRequest request, HttpServletResponse response) throws Exception;

    /**
     * 获取用户订单列表
     * @param query
     * @return
     */
    List<OrderListResponse> getOrderList(UserInfoQuery query);
}
