package com.aiup.service.service.impl;

import com.aiup.service.domain.query.ConfigListQuery;
import com.aiup.service.entity.UserConfig;
import com.aiup.service.dao.UserConfigDao;
import com.aiup.service.service.UserConfigService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户配置信息(UserConfig)表服务实现类
 *
 * @author makejava
 * @since 2023-08-29 16:49:49
 */
@Service("userConfigService")
public class UserConfigServiceImpl implements UserConfigService {
    @Resource
    private UserConfigDao userConfigDao;

    /**
     * 通过ID查询单条数据
     *
     * @param configId 主键
     * @return 实例对象
     */
    @Override
    public UserConfig queryById(Integer configId) {
        return this.userConfigDao.queryById(configId);
    }

    /**
     * 分页查询
     *
     * @param userConfig  筛选条件
     * @param pageRequest 分页对象
     * @return 查询结果
     */
    @Override
    public Page<UserConfig> queryByPage(UserConfig userConfig, PageRequest pageRequest) {
        long total = this.userConfigDao.count(userConfig);
        return new PageImpl<>(this.userConfigDao.queryAllByLimit(userConfig, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param userConfig 实例对象
     * @return 实例对象
     */
    @Override
    public UserConfig insert(UserConfig userConfig) {
        this.userConfigDao.insert(userConfig);
        return userConfig;
    }

    /**
     * 修改数据
     *
     * @param userConfig 实例对象
     * @return 实例对象
     */
    @Override
    public UserConfig update(UserConfig userConfig) {
        this.userConfigDao.update(userConfig);
        return this.queryById(userConfig.getConfigId());
    }

    /**
     * 通过主键删除数据
     *
     * @param configId 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer configId) {
        return this.userConfigDao.deleteById(configId) > 0;
    }

    @Override
    public List<UserConfig> getListByType(ConfigListQuery query) {
        return this.userConfigDao.getListByType(query);
    }
}
