package com.aiup.service.service.impl;

import com.aiup.service.domain.query.NoteTaskListQuery;
import com.aiup.service.domain.query.UserInfoQuery;
import com.aiup.service.domain.response.NoteTaskDistributionResponse;
import com.aiup.service.entity.UserNotesTask;
import com.aiup.service.dao.UserNotesTaskDao;
import com.aiup.service.service.UserNotesTaskService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户任务队列(UserNotesTask)表服务实现类
 *
 * @author makejava
 * @since 2023-08-28 16:50:24
 */
@Service("userNotesTaskService")
public class UserNotesTaskServiceImpl implements UserNotesTaskService {
    @Resource
    private UserNotesTaskDao userNotesTaskDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public UserNotesTask queryById(Integer id) {
        return this.userNotesTaskDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param userNotesTask 筛选条件
     * @param pageRequest   分页对象
     * @return 查询结果
     */
    @Override
    public Page<UserNotesTask> queryByPage(UserNotesTask userNotesTask, PageRequest pageRequest) {
        long total = this.userNotesTaskDao.count(userNotesTask);
        return new PageImpl<>(this.userNotesTaskDao.queryAllByLimit(userNotesTask, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param userNotesTask 实例对象
     * @return 实例对象
     */
    @Override
    public UserNotesTask insert(UserNotesTask userNotesTask) {
        this.userNotesTaskDao.insert(userNotesTask);
        return userNotesTask;
    }

    /**
     * 修改数据
     *
     * @param userNotesTask 实例对象
     * @return 实例对象
     */
    @Override
    public UserNotesTask update(UserNotesTask userNotesTask) {
        this.userNotesTaskDao.update(userNotesTask);
        return this.queryById(userNotesTask.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.userNotesTaskDao.deleteById(id) > 0;
    }

    @Override
    public List<UserNotesTask> getListByUser(NoteTaskListQuery query) {
        return this.userNotesTaskDao.getListByUser(query);
    }

    @Override
    public List<NoteTaskDistributionResponse> getTaskDistribution(NoteTaskListQuery query) {
        return this.userNotesTaskDao.getTaskDistribution(query);
    }


}
