package com.aiup.service.service.impl;

import com.aiup.service.entity.XhsNotesKeywords;
import com.aiup.service.dao.XhsNotesKeywordsDao;
import com.aiup.service.service.XhsNotesKeywordsService;
import org.springframework.stereotype.Service;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;

import javax.annotation.Resource;

/**
 * (XhsNotesKeywords)表服务实现类
 *
 * @author makejava
 * @since 2023-08-15 13:14:03
 */
@Service("xhsNotesKeywordsService")
public class XhsNotesKeywordsServiceImpl implements XhsNotesKeywordsService {
    @Resource
    private XhsNotesKeywordsDao xhsNotesKeywordsDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public XhsNotesKeywords queryById(Integer id) {
        return this.xhsNotesKeywordsDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param xhsNotesKeywords 筛选条件
     * @param pageRequest      分页对象
     * @return 查询结果
     */
    @Override
    public Page<XhsNotesKeywords> queryByPage(XhsNotesKeywords xhsNotesKeywords, PageRequest pageRequest) {
        long total = this.xhsNotesKeywordsDao.count(xhsNotesKeywords);
        return new PageImpl<>(this.xhsNotesKeywordsDao.queryAllByLimit(xhsNotesKeywords, pageRequest), pageRequest, total);
    }

    /**
     * 新增数据
     *
     * @param xhsNotesKeywords 实例对象
     * @return 实例对象
     */
    @Override
    public XhsNotesKeywords insert(XhsNotesKeywords xhsNotesKeywords) {
        this.xhsNotesKeywordsDao.insert(xhsNotesKeywords);
        return xhsNotesKeywords;
    }

    /**
     * 修改数据
     *
     * @param xhsNotesKeywords 实例对象
     * @return 实例对象
     */
    @Override
    public XhsNotesKeywords update(XhsNotesKeywords xhsNotesKeywords) {
        this.xhsNotesKeywordsDao.update(xhsNotesKeywords);
        return this.queryById(xhsNotesKeywords.getId());
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public boolean deleteById(Integer id) {
        return this.xhsNotesKeywordsDao.deleteById(id) > 0;
    }
}
