package com.aiup.service.utils;

import com.aiup.service.entity.UserInfo;

public abstract class LoginUserUtils {

    //线程变量，存放user实体类信息，即使是静态的与其他线程也是隔离的
    private static final ThreadLocal<UserInfo> userThreadLocal = new ThreadLocal<>();

    //获取当前登录用户
    public static UserInfo getLoginUser() {
        return userThreadLocal.get();
    }

    public static void setLoginUser(UserInfo user) {
        userThreadLocal.set(user);
    }

    public static void removeUser(){
        userThreadLocal.remove();
    }
}

