/**
 * Copyright (C), 2015-2020, XXX公司
 * FileName: CacheUtils
 * Author:   hanyu
 * Date:     2020/03/23 10:05
 * Description:
 */
package com.aiup.service.utils;


import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class RedisUtil {

    @Autowired
    private JedisCluster jedisCluster;

    /**
     * 获取redis key
     *
     * @param key
     * @return
     */
    public String getRedisKey(String key) {
        return "aiup:" + key;
    }

    public JedisCluster getJedisCluster() {
        return jedisCluster;
    }




//    public long del(String key) {
//        String redisKey = getRedisKey(key);
//        return jedisCluster.del(key);
//    }

    /**
     * 缓存前缀不用自己拼接
     *
     * @param key
     * @return
     */
    public long delKey(String key) {
        String redisKey = getRedisKey(key);
        return jedisCluster.del(redisKey);
    }

    public Long expire(String key, int seconds) {
        String redisKey = getRedisKey(key);
        return jedisCluster.expire(redisKey, seconds);
    }

    public Boolean exists(String key) {
        String redisKey = getRedisKey(key);
        return jedisCluster.exists(redisKey);
    }


//  String ————————————————————————————————————————————————————————————————————————————————————-

    public void set(String key, String value, int seconds) {
        String redisKey = getRedisKey(key);
        jedisCluster.set(redisKey, value);
        if (seconds > 0) {
            jedisCluster.expire(redisKey, seconds);
        }
    }

    public <T> void set(String key, T value, int seconds) {
        String json = JSON.toJSONString(value);
        set(key, json, seconds);
    }


    public void set(String key, String value) {
        set(key, value, 0);
    }

    public <T> void set(String key, T value) {
        String json = JSON.toJSONString(value);
        set(key, json);
    }


    public String get(String key) {
        String redisKey = getRedisKey(key);
        return jedisCluster.get(redisKey);
    }

    public <T> T get(String key, Class<T> tClass) {
        String redisKey = getRedisKey(key);
        String result = jedisCluster.get(redisKey);
        if (!StringUtils.isEmpty(result)) {
            return JSON.parseObject(result, tClass);
        }
        return null;
    }

    public <T> List<T> getToList(String key, Class<T> tClass) {
        String redisKey = getRedisKey(key);
        String result = jedisCluster.get(redisKey);
        if (!StringUtils.isEmpty(result)) {
            return JSON.parseArray(result, tClass);
        }
        return null;
    }

    //  String ————————————————————————————————————————————————————————————————————————————————————-


//  Hash ————————————————————————————————————————————————————————————————————————————————————-

    public Boolean hexists(String key, String field) {
        String redisKey = getRedisKey(key);
        return jedisCluster.hexists(redisKey, field);
    }

    public Long hdel(String key, String field) {
        String redisKey = getRedisKey(key);
        return jedisCluster.hdel(redisKey, field);
    }

    public Long hdel(String key, List<String> fields) {
        String redisKey = getRedisKey(key);
        String[] strs1 = fields.toArray(new String[fields.size()]);
        return jedisCluster.hdel(redisKey, strs1);
    }


    public void hset(String key, String field, String value, int seconds) {
        String redisKey = getRedisKey(key);
        jedisCluster.hset(redisKey, field, value);
        if (seconds > 0) {
            jedisCluster.expire(redisKey, seconds);
        }
    }

    public <T> void hset(String key, String field, T value, int seconds) {
        String json = JSON.toJSONString(value);
        hset(key, field, json, seconds);
    }


    public void hset(String key, String field, String value) {
        hset(key, field, value, 0);
    }

    public <T> void hset(String key, String field, T value) {
        String json = JSON.toJSONString(value);
        hset(key, field, json);
    }


    public void hmset(String key, Map<String, String> hash, int seconds) {
        String redisKey = getRedisKey(key);
        jedisCluster.hmset(redisKey, hash);
        if (seconds > 0) {
            jedisCluster.expire(redisKey, seconds);
        }
    }


    public void hmset(String key, Map<String, String> hash) {
        hmset(key, hash, 0);
    }


    public String hget(String key, String field) {
        String redisKey = getRedisKey(key);
        return jedisCluster.hget(redisKey, field);
    }

    public <T> T hget(String key, String field, Class<T> tClass) {
        String redisKey = getRedisKey(key);
        String result = jedisCluster.hget(redisKey, field);
        if (!StringUtils.isEmpty(result)) {
            return JSON.parseObject(result, tClass);
        }
        return null;
    }

    public <T> List<T> hgetToList(String key, String field, Class<T> tClass) {
        String redisKey = getRedisKey(key);
        String result = jedisCluster.hget(redisKey, field);
        if (!StringUtils.isEmpty(result)) {
            return JSON.parseArray(result, tClass);
        }
        return null;
    }


    public List<String> hmget(String key, List<String> fields) {
        String redisKey = getRedisKey(key);
        String[] strs1 = fields.toArray(new String[fields.size()]);
        return jedisCluster.hmget(redisKey, strs1);
    }


    public Map<String, String> hmgetToMap(String key, List<String> fields) {
        String redisKey = getRedisKey(key);
        Map<String, String> map = hgetAll(redisKey);
        if (map == null || map.size() == 0) {
            return null;
        }
        Map<String, String> result = new HashMap<String, String>();
        for (String item : map.keySet()) {
            if (!StringUtils.isEmpty(map.get(item))) {
                result.put(item, map.get(item));
            }
        }
        return result;
    }

    public <T> Map<String, T> hmgetToMap(String key, Class<T> tClass) {
        String redisKey = getRedisKey(key);
        Map<String, String> map = hgetAll(redisKey);
        if (map == null || map.size() == 0) {
            return null;
        }
        Map<String, T> result = new HashMap<String, T>();
        for (String item : map.keySet()) {
            if (!StringUtils.isEmpty(map.get(item))) {
                if (!StringUtils.isEmpty(map.get(item))) {
                    T t = JSON.parseObject(map.get(item), tClass);
                    result.put(item, t);
                }
            }
        }
        return result;
    }


    public <T> List<T> hmget(String key, List<String> fields, Class<T> tClass) {
        List<String> list = hmget(key, fields);
        if (list == null || list.size() == 0) {
            return null;
        }
        List<T> result = new ArrayList<T>();
        for (String item : list) {
            if (!StringUtils.isEmpty(item)) {
                T t = JSON.parseObject(item, tClass);
                result.add(t);
            }
        }
        return result;
    }


    public Map<String, String> hgetAll(String key) {
        String redisKey = getRedisKey(key);
        return jedisCluster.hgetAll(key);
    }


    public <T> Map<String, T> hgetAll(String key, Class<T> tClass) {
        Map<String, String> map = hgetAll(key);
        if (map == null || map.size() == 0) {
            return null;
        }
        Map<String, T> result = new HashMap<String, T>();
        for (String item : map.keySet()) {
            if (!StringUtils.isEmpty(map.get(item))) {
                T t = JSON.parseObject(map.get(item), tClass);
                result.put(item, t);
            }
        }
        return result;
    }

    public Long hincrBy(String key, String field, long value) {
        String redisKey = getRedisKey(key);
        return jedisCluster.hincrBy(redisKey, field, value);
    }


//  Hash ————————————————————————————————————————————————————————————————————————————————————-


    public void test() {


    }

}