#!/bin/sh

    #程序绝对路径
    APP_JAR="/data/aiup/task/task-1.0.0.jar"
    #程序环境配置
    APP_CONF=" --spring.profiles.active=prod"


    source /etc/profile
    TIME_STAMP=`date '+%Y-%m-%d %H:%M:%S'`
    WHO=`whoami`
    if readlink -f "$0" > /dev/null 2>&1
    then
      SHELL_BIN=$(readlink -f "$0")
    else
      SHELL_BIN="$0"
    fi
    BIN_HOME=$(dirname $SHELL_BIN)
    APP_HOME=$(dirname $APP_JAR)

    GC_LOGS=$APP_HOME
    PID_LOG=$APP_HOME/pid

    #JVM启动参数
    JAVA_OPTS="-Dreactor.netty.pool.leasingStrategy=lifo -Dlog4j2.formatMsgNoLookups=true -Dfile.encoding=UTF-8 -server -Xms2g -Xmx2g -XX:MetaspaceSize=256m -XX:MaxMetaspaceSize=256m -XX:+PrintGCDetails -XX:+PrintGCDateStamps -XX:+PrintGCApplicationConcurrentTime -XX:+PrintHeapAtGC -XX:+UseGCLogFileRotation -Xloggc:/data/logs/apup/task/gc.log -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=5M  -XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=/data/logs/aiuu/task/"
    JAVA=`which java`

    #打印环境变量
    echo "======================================================================================"
    echo "TIME_STAMP: "$TIME_STAMP
    echo "WHO: "$WHO
    echo "SHELL_BIN: "$SHELL_BIN
    echo "BIN_HOME:  "$BIN_HOME
    echo "APP_HOME:  "$APP_HOME
    echo "PID_LOG:   "$PID_LOG
    echo "JAVA_HOME: "$JAVA_HOME
    echo "JAVA_OPTS: "$JAVA_OPTS
    echo "APP_JAR: "$APP_JAR
    echo "======================================================================================"

    start(){
    echo "Starting Now... "

        nohup $JAVA -jar $JAVA_OPTS $APP_JAR $APP_CONF  > "$APP_HOME/start.log" 2>&1 &

        if [ $? -eq 0 ];
        then
            if /bin/echo -n $! > "$PID_LOG"
            then
            sleep 1
                echo "PID:$!"
                echo STARTED
                echo "SUCCESS"
                echo "application start success "
            else
            echo FAILED TO WRITE PID
            exit 1
            fi
        else
            echo WOKRE DID NOT START
            exit 1
        fi
    }

    stop(){
        PID=$(ps -ef | grep $APP_JAR | grep -v grep | awk '{ print $2 }')
        if [ -z "$PID" ]
        then
            echo "Application is already stopped"
        else
            echo kill $PID
                        sleep 1
            kill -9 $PID
        fi
    }


    case "$1" in

        start)
        start
        ;;

        stop)
        stop
        ;;

        restart)
        stop
        start
        ;;

        *)
        echo 'Usage command: {start|stop|restart}\n'
        exit 1
        ;;
    esac

    exit 0
﻿